#include "General.h"
#include "RemoteScreenshot.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"
#include "GameObjManager.h"
#include "SmartGameObj.h"
#include "cPlayer.h"

int RemoteScreenshot::AutoSSInterval = 60;

void PPage(int ID, const char* rgb_colour, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Console("ppage %d %s",ID, buffer);
                return;
	}
	else
	{
		Console("cmsgp %d %s %s", ID, rgb_colour, buffer);
	}
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Do_Remote_Screenshots_All_Players()
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Commands->Is_A_Star(o))
			{
				int ID = Get_Player_ID(o);
				Console("sshot %d", ID);
//				Console_Output("Doing remote screenshot for player ID: %d\n", ID); // DEBUG CRAP
			}
		}
		x = x->Next();
	}
}

RemoteScreenshot::RemoteScreenshot()
{
	UploadURL = "ERR";
	AutoSSInterval = 60;
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

RemoteScreenshot::~RemoteScreenshot()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void RemoteScreenshot::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	SSGMIni->Get_String(UploadURL, "RemoteScreenshot", "UploadURL", "ERR");
	RemoteScreenshot::AutoSSInterval = SSGMIni->Get_Int("RemoteScreenshot", "AutoSSInterval", 60);

	if (UploadURL == "ERR")
	{
		MessageBox(NULL,"Error reading the upload script URL from \"UploadURL=\" under [RemoteScreenshot] in SSGM.ini","Fatal Error!",MB_OK|MB_ICONEXCLAMATION|MB_TOPMOST);
	}
}


bool RemoteScreenshot::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Message[0] == L'!')
	{
		if (wcsistr(Message,L"!ss") == Message)
		{
			Do_Remote_Screenshots_All_Players();
		}
	}
	return true;
}

void RemoteScreenshot::OnLoadLevel()
{
	if (UploadURL == "ERR")
	{
		MessageBox(NULL,"Error reading the upload script URL from \"UploadURL=\" under [RemoteScreenshot] in SSGM.ini","Fatal Error!",MB_OK|MB_ICONEXCLAMATION|MB_TOPMOST);
	}
	else
	{
		Console("ssurl %s", UploadURL.Peek_Buffer());
	}
	GameObject* obj = Commands->Create_Object("Invisible_Object", Vector3(0.0f,0.0f,0.0f));
	Attach_Script_Once(obj,"Remote_Screenshot_Timer","");
}


void Remote_Screenshot_Timer::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this,(float)RemoteScreenshot::AutoSSInterval, 1);
}

void Remote_Screenshot_Timer::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		Do_Remote_Screenshots_All_Players();
		Commands->Start_Timer(obj, this,(float)RemoteScreenshot::AutoSSInterval, 1);
	}
}

ScriptRegistrant<Remote_Screenshot_Timer> Remote_Screenshot_Timer_Registrant("Remote_Screenshot_Timer","");

RemoteScreenshot remoteScreenshot;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &remoteScreenshot;
}
